//=============================================================================
// MarkusPlayer.
//
// Custom player class for the markistan mod.
//=============================================================================
class MarkusGrayMale extends JCDentonMale; 

var travel int Photons;
var travel int Metals;
var travel int Spices;
var travel int Sugar;
var travel int Fruit;
var travel int Soy;
var travel int Chocolate;
var travel int Bread;
var travel int DeadCats;
var travel int DeadDogs;
var travel int DeadDragons;
var travel int DeadGreasels;
var travel int DeadKarkians;
var travel int DeadBigDragons;
var bool bCanAirJump;

function DoJump( optional float F )
{
	local DeusExWeapon w;
	local float scaleFactor, augLevel;

	if ( (CarriedDecoration != None) && (CarriedDecoration.Mass > 20) )
		return;
	else if ( bForceDuck || IsLeaning() )
		return;

	if ( Physics == PHYS_Walking )
	{
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.05*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ;
					
		if ( Base != Level )
			Velocity.Z += Base.Velocity.Z;
		SetPhysics(PHYS_Falling);
		bCanAirJump = True;
		if ( bCountJumps && (Role == ROLE_Authority) )
			Inventory.OwnerJumped();
	}

	else if ( (Physics == PHYS_Falling) && bCanAirJump )
	{
		bCanAirJump = False;
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.05*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ;	
		SetPhysics(PHYS_Falling);
		if ( bCountJumps && (Role == ROLE_Authority) )
			Inventory.OwnerJumped();
	}
}

exec function AugAdd(class<Augmentation> aWantedAug)
{
}

exec function Tantalus()
{
}

exec function OpenSesame()
{
}

exec function AllAugs()
{
}

exec function Invisible(bool B)
{
}

exec function AllSkills()
{
}

exec function AllHealth()
{
}

exec function Ow()
{
	if (!bCheatsEnabled)
		return;

	RestoreAllHealth();
}

exec function AllEnergy()
{
}

exec function SugarRush()
{
	if (!bCheatsEnabled)
		return;

	Energy = 9999;
}

exec function AllWeapons()
{
}

exec function SloMo( float T )
{
}

exec function AllAmmo()
{
}	

exec function LockAndLoad()
{
	local Inventory Inv;

	if( !bCheatsEnabled )
		return;

	if ( !bAdmin && (Level.Netmode != NM_Standalone) )
		return;

	// DEUS_EX CNN - make this be limited by the MaxAmmo per ammo instead of 999
	for( Inv=Inventory; Inv!=None; Inv=Inv.Inventory ) 
		if (Ammo(Inv)!=None) 
			Ammo(Inv).AmmoAmount  = Ammo(Inv).MaxAmmo;
}	

function RestoreAllHealth()
{
	HealthHead = default.HealthHead;
	HealthTorso = default.HealthTorso;
	HealthLegLeft = default.HealthLegLeft;
	HealthLegRight = default.HealthLegRight;
	HealthArmLeft = default.HealthArmLeft;
	HealthArmRight = default.HealthArmRight;
	Health = default.Health;
}

exec function TehLeet()
{
	if (!bCheatsEnabled)
		return;

	AllSkillPoints();
	SkillSystem.AddAllSkills();
}

exec function SpawnMass(Name ClassName, optional int TotalCount)
{
	local actor        spawnee;
	local vector       spawnPos;
	local vector       center;
	local rotator      direction;
	local int          maxTries;
	local int          count;
	local int          numTries;
	local float        maxRange;
	local float        range;
	local float        angle;
	local class<Actor> spawnClass;
	local string		holdName;

	if (!bCheatsEnabled)
		return;

	if (!bAdmin && (Level.Netmode != NM_Standalone))
		return;

	if (instr(ClassName, ".") == -1)
		holdName = "Markistan." $ ClassName;
	else
		holdName = "" $ ClassName;  // barf

	spawnClass = class<actor>(DynamicLoadObject(holdName, class'Class'));
	if (spawnClass == None)
	{
		ClientMessage("Illegal actor name "$GetItemName(String(ClassName)));
		return;
	}

	if (totalCount <= 0)
		totalCount = 10;
	if (totalCount > 250)
		totalCount = 250;
	maxTries = totalCount*2;
	count = 0;
	numTries = 0;
	maxRange = sqrt(totalCount/3.1416)*4*SpawnClass.Default.CollisionRadius;

	direction = ViewRotation;
	direction.pitch = 0;
	direction.roll  = 0;
	center = Location + Vector(direction)*(maxRange+SpawnClass.Default.CollisionRadius+CollisionRadius+20);
	while ((count < totalCount) && (numTries < maxTries))
	{
		angle = FRand()*3.14159265359*2;
		range = sqrt(FRand())*maxRange;
		spawnPos.X = sin(angle)*range;
		spawnPos.Y = cos(angle)*range;
		spawnPos.Z = 0;
		spawnee = spawn(SpawnClass,,,center+spawnPos, Rotation);
		if (spawnee != None)
			count++;
		numTries++;
	}

	ClientMessage(count$" actor(s) spawned");

}


exec function Summon(string ClassName)
{
	if (!bCheatsEnabled)
		return;

	if(!bAdmin && (Level.Netmode != NM_Standalone))
		return;
	if(instr(ClassName, ".") == -1)
		ClassName = "Markistan." $ ClassName;
	Super.Summon(ClassName);
}

// ----------------------------------------------------------------------
// HandleItemPickup()
// ----------------------------------------------------------------------

function bool HandleItemPickup(Actor FrobTarget, optional bool bSearchOnly)
{
	local bool bCanPickup;
	local bool bSlotSearchNeeded;
	local Inventory foundItem;

	bSlotSearchNeeded = True;
	bCanPickup = True;

	// Special checks for objects that do not require phsyical inventory
	// in order to be picked up:
	// 
	// - NanoKeys
	// - DataVaultImages
	// - Credits

	if ((FrobTarget.IsA('DataVaultImage')) || (FrobTarget.IsA('NanoKey')) || (FrobTarget.IsA('Credits')) || (FrobTarget.IsA('Photons')) || (FrobTarget.IsA('CookingSupplies')) || (FrobTarget.IsA('DeadStuff')) || (FrobTarget.IsA('Dollar')) || (FrobTarget.IsA('Dollar2')) || (FrobTarget.IsA('Metals'))) 
	{
		bSlotSearchNeeded = False;
	}
	else if (FrobTarget.IsA('DeusExPickup'))
	{
		// If an object of this type already exists in the player's inventory *AND*
		// the object is stackable, then we don't need to search.

		if ((FindInventoryType(FrobTarget.Class) != None) && (DeusExPickup(FrobTarget).bCanHaveMultipleCopies))
			bSlotSearchNeeded = False;
	}
	else 
	{
		// If this isn't ammo or a weapon that we already have, 
		// check if there's enough room in the player's inventory
		// to hold this item.

		foundItem = GetWeaponOrAmmo(Inventory(FrobTarget));

		if (foundItem != None)
		{
			bSlotSearchNeeded = False;

			// if this is an ammo, and we're full of it, abort the pickup
			if (foundItem.IsA('Ammo'))
			{
				if (Ammo(foundItem).AmmoAmount >= Ammo(foundItem).MaxAmmo)
				{
					ClientMessage(TooMuchAmmo);
					bCanPickup = False;
				}
			}

			// If this is a grenade or LAM (what a pain in the ass) then also check
			// to make sure we don't have too many grenades already
			else if ((foundItem.IsA('WeaponEMPGrenade')) || 
			    (foundItem.IsA('WeaponGasGrenade')) || 
				(foundItem.IsA('WeaponNanoVirusGrenade')) || 
				(foundItem.IsA('WeaponLAM')))
			{
				if (DeusExWeapon(foundItem).AmmoType.AmmoAmount >= DeusExWeapon(foundItem).AmmoType.MaxAmmo)
				{
					ClientMessage(TooMuchAmmo);
					bCanPickup = False;
				}
			}


			// Otherwise, if this is a single-use weapon, prevent the player
			// from picking up

			else if (foundItem.IsA('Weapon'))
			{
				// If these fields are set as checked, then this is a 
				// single use weapon, and if we already have one in our 
				// inventory another cannot be picked up (puke). 

				bCanPickup = ! ( (Weapon(foundItem).ReloadCount == 0) && 
				                 (Weapon(foundItem).PickupAmmoCount == 0) && 
				                 (Weapon(foundItem).AmmoName != None) );

				if (!bCanPickup)
					ClientMessage(Sprintf(CanCarryOnlyOne, foundItem.itemName));

			}
		}
	}
	
	if (bSlotSearchNeeded && bCanPickup)
	{
		if (FindInventorySlot(Inventory(FrobTarget), bSearchOnly) == False)
		{
			ClientMessage(Sprintf(InventoryFull, Inventory(FrobTarget).itemName));
			bCanPickup = False;
			ServerConditionalNotifyMsg( MPMSG_DropItem );
		}
	}
	
	if (bCanPickup)
	{
		if ( (Level.NetMode != NM_Standalone) && (FrobTarget.IsA('DeusExWeapon') || FrobTarget.IsA('DeusExAmmo')) )
			PlaySound(sound'WeaponPickup', SLOT_Interact, 0.5+FRand()*0.25, , 256, 0.95+FRand()*0.1);
		DoFrob(Self, inHand);

		// This is bad. We need to reset the number so restocking works
		if ( Level.NetMode != NM_Standalone )
		{
			if ( FrobTarget.IsA('DeusExWeapon') && (DeusExWeapon(FrobTarget).PickupAmmoCount == 0) )
			{
				DeusExWeapon(FrobTarget).PickupAmmoCount = DeusExWeapon(FrobTarget).Default.mpPickupAmmoCount * 3;
			}
		}
	}

	return bCanPickup;
}

exec function God()
{
}

exec function Ghost()
{
}

exec function Fly()
{
}

exec function AllCredits()
{
}

// ----------------------------------------------------------------------
// SwissBanker()
// ----------------------------------------------------------------------

exec function SwissBanker()
{
	local Vector loc;
        local MarkusGrayMale P;

	if (!bCheatsEnabled)
		return;

	loc = Location + 2 * CollisionRadius * Vector(ViewRotation);

	Spawn(class'Markistan.MarkusWallet',,, loc);
	Credits = 1000000;
}

// ----------------------------------------------------------------------
// ComplimentsToTheChef()
// ----------------------------------------------------------------------

exec function ComplimentsToTheChef()
{
	local Vector loc;
        local MarkusGrayMale P;

	if (!bCheatsEnabled)
		return;

	loc = Location + 2 * CollisionRadius * Vector(ViewRotation);

	Spawn(class'Markistan.CookingPot',,, loc);
	Bread = 1000000000;
	Chocolate = 1000000000;
	Fruit = 1000000000;
	Soy = 1000000000;
	Spices = 1000000000;
	Sugar = 1000000000;
}

// ----------------------------------------------------------------------
// Blacksmith()
// ----------------------------------------------------------------------

exec function Blacksmith()
{
	local Vector loc;
        local MarkusGrayMale P;

	if (!bCheatsEnabled)
		return;

	loc = Location + 2 * CollisionRadius * Vector(ViewRotation);

	Spawn(class'Markistan.FCCrafter',,, loc);
	Spawn(class'Markistan.FWCrafter',,, loc);
	Spawn(class'Markistan.CraftingAnvil',,, loc);
	Photons = 1000000000;
	Metals = 1000000000;
}

// ----------------------------------------------------------------------
// PhotonArsenal()
// ----------------------------------------------------------------------

exec function PhotonArsenal()
{
	local Vector loc;

	if (!bCheatsEnabled)
		return;

	loc = Location + 2 * CollisionRadius * Vector(ViewRotation);

	Spawn(class'Markistan.WeaponM23',,, loc);
	Spawn(class'Markistan.WeaponPhotonPistol',,, loc);
	Spawn(class'Markistan.WeaponPhotonShotgun',,, loc);
	Spawn(class'Markistan.WeaponPhotonTacticalShotgun',,, loc);
	Spawn(class'Markistan.WeaponPhotonSniperRifle',,, loc);
	Spawn(class'Markistan.WeaponBallisticRifle',,, loc);
	Spawn(class'Markistan.WeaponDevestator',,, loc);
	Spawn(class'Markistan.AmmoRedPhoton',,, loc);
	Spawn(class'Markistan.AmmoOrangePhoton',,, loc);
	Spawn(class'Markistan.AmmoWhitePhoton',,, loc);
}

// ----------------------------------------------------------------------
// ImLonely()
// ----------------------------------------------------------------------

exec function ImLonely()
{
	local Vector loc;

	if (!bCheatsEnabled)
		return;

	loc = Location + 2 * CollisionRadius * Vector(ViewRotation);

	Spawn(class'Markistan.CompanionCube',,, loc);
	Spawn(class'Markistan.HALPAgent',,, loc);
	Spawn(class'Markistan.HALPAgent',,, loc);
	Spawn(class'Markistan.HALPAgent',,, loc);
}

// ----------------------------------------------------------------------
// BeastMaster()
// ----------------------------------------------------------------------

exec function BeastMaster()
{
	local Vector loc;

	if (!bCheatsEnabled)
		return;

	loc = Location + 2 * CollisionRadius * Vector(ViewRotation);

	Spawn(class'Markistan.CatPet',,, loc);
	Spawn(class'Markistan.DogPet',,, loc);
	Spawn(class'Markistan.DragonPet',,, loc);
	Spawn(class'Markistan.GreaselPet',,, loc);
	Spawn(class'Markistan.KarkianPet',,, loc);
	Spawn(class'Markistan.BigDragonPet',,, loc);
	Spawn(class'Markistan.RevivalKit',,, loc);
}

function ResetPlayer(optional bool bTraining)
{
	local inventory anItem;
	local inventory nextItem;

	ResetPlayerToDefaults();

	// Reset Augmentations
	if (AugmentationSystem != None)
	{
		AugmentationSystem.ResetAugmentations();
		AugmentationSystem.Destroy();
		AugmentationSystem = None;
	}

	// Give the player a nano-wallet and a usp match
        //Added function swiped from training mission to prevent an inventory bug.
	if (!bTraining)
	{
		RemoveAllInventory();
		anItem = Spawn(class'Markistan.WeaponUSPMatch');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
		anItem = Spawn(class'Markistan.MarkusWallet');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
		anItem = Spawn(class'Markistan.SoyMeal2');
                anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
	}
}

exec function WhatsThisButtonDo()
{
	local Vector loc;
        local MarkusGrayMale P;

	if (!bCheatsEnabled)
		return;

	loc = Location + 2 * CollisionRadius * Vector(ViewRotation);

	Spawn(class'Markistan.FCCrafter',,, loc);
	Spawn(class'Markistan.FWCrafter',,, loc);
	Spawn(class'Markistan.CraftingAnvil',,, loc);
	Spawn(class'Markistan.RevivalKit',,, loc);
	Spawn(class'Markistan.MarkusWallet',,, loc);
	Spawn(class'Markistan.CookingPot',,, loc);
}

//-----------------------------------------------------------
// ShowMainMenu()
//
// Overridden to allow custom text above the main menu
//-----------------------------------------------------------

exec function ShowMainMenu()
{
     local DeusExRootWindow root;
     local DeusExLevelInfo info;
     local MissionEndgame Script;

     if (bIgnoreNextShowMenu)
     {
          bIgnoreNextShowMenu = False;
          return;
     }

     info = GetLevelInfo();

     // Special case baby!
     // 
     // If the Intro map is loaded and we get here, that means the player
     // pressed Escape and we want to either A) start a new game 
     // or B) return to the dx.dx screen.  Either way we're going to 
     // abort the Intro by doing this. 
     //
     // If this is one of the Endgames (which have a mission # of 99)
     // then we also want to call the Endgame's "FinishCinematic" 
     // function

     // force the texture caches to flush
     ConsoleCommand("FLUSH");

     if ((info != None) && (info.MissionNumber == 98)) 
     {
          bIgnoreNextShowMenu = True;
          PostIntro();
     }
     else if ((info != None) && (info.MissionNumber == 99))
     {
          foreach AllActors(class'MissionEndgame', Script)
               break;

          if (Script != None)
               Script.FinishCinematic();
     }
     else
     {
          root = DeusExRootWindow(rootWindow);
          if (root != None){
             root.InvokeMenu(Class'Markistan.MarkistanMenuMain');
          }
     }
}


// ----------------------------------------------------------------------
// Override ShowIntro() to play a custom intro map
// ----------------------------------------------------------------------
function ShowIntro(optional bool bStartNewGame)
{
	if (DeusExRootWindow(rootWindow) != None)
		DeusExRootWindow(rootWindow).ClearWindowStack();

	bStartNewGameAfterIntro = bStartNewGame;

	// Make sure all augmentations are OFF before going into the intro
	AugmentationSystem.DeactivateAll();

	// Reset the player
	Level.Game.SendPlayer(Self, "16_Markistan_Intro");

}


// ----------------------------------------------------------------------
// TravelPostAccept()
// ----------------------------------------------------------------------

event TravelPostAccept()
{
    local DeusExLevelInfo info;

    local Skill aSkill;
    local int i;

//       Super.TravelPostAccept();
//     MultiSkins(0)=Texture'Markistan.Skins.MarkusTex0'
//     MultiSkins(1)=Texture'Markistan.Skins.MarkusTex2'
//     MultiSkins(3)=Texture'Markistan.Skins.MarkusTex0'
//     MultiSkins(4)=Texture'Markistan.Skins.MarkusTex1'
//     MultiSkins(5)=Texture'Markistan.Skins.MarkusTex2'
	Super(JCDentonMale).TravelPostAccept();

	switch(PlayerSkin)
	{
		case 0:	MultiSkins[0] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[1] = Texture'Markistan.Skins.MarkusTex2';
			MultiSkins[3] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[4] = Texture'Markistan.Skins.MarkusTex1';
			MultiSkins[5] = Texture'Markistan.Skins.MarkusTex2';
			break;
		case 1:	MultiSkins[0] = Texture'Markistan.Skins.TylerTex0';
			MultiSkins[1] = Texture'Markistan.Skins.TylerTex2';
			MultiSkins[3] = Texture'Markistan.Skins.TylerTex0';
			MultiSkins[4] = Texture'Markistan.Skins.TylerTex1';
			MultiSkins[5] = Texture'Markistan.Skins.TylerTex2';
			break;
		case 2:	MultiSkins[0] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[1] = Texture'Markistan.Skins.MarkusTex2';
			MultiSkins[3] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[4] = Texture'Markistan.Skins.MarkusTex1';
			MultiSkins[5] = Texture'Markistan.Skins.MarkusTex2';
			break;
		case 3:	MultiSkins[0] = Texture'Markistan.Skins.TylerTex0';
			MultiSkins[1] = Texture'Markistan.Skins.TylerTex2';
			MultiSkins[3] = Texture'Markistan.Skins.TylerTex0';
			MultiSkins[4] = Texture'Markistan.Skins.TylerTex1';
			MultiSkins[5] = Texture'Markistan.Skins.TylerTex2';
			break;
		case 4:MultiSkins[0] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[1] = Texture'Markistan.Skins.MarkusTex2';
			MultiSkins[3] = Texture'Markistan.Skins.MarkusTex0';
			MultiSkins[4] = Texture'Markistan.Skins.MarkusTex1';
			MultiSkins[5] = Texture'Markistan.Skins.MarkusTex2';
			break;
	}
}



// ----------------------------------------------------------------------
// StartDataLinkTransmission()
//
// Locates and starts the DataLink passed in
// This has been overridden in order to call the custom RedsunDataLinkPlay
// so that InfoLink's without recorded dialogue can be slowed down.
// ----------------------------------------------------------------------

function Bool StartDataLinkTransmission(
	String datalinkName, 
	Optional DataLinkTrigger datalinkTrigger)
{
	local Conversation activeDataLink;
	local bool bDataLinkPlaySpawned;

	// Don't allow DataLinks to start if we're in PlayersOnly mode
	if ( Level.bPlayersOnly )
		return False;

	activeDataLink = GetActiveDataLink(datalinkName);

	if ( activeDataLink != None )
	{
		// Search to see if there's an active DataLinkPlay object 
		// before creating one

		if ( dataLinkPlay == None )
		{
			datalinkPlay = Spawn(class'MarkistanDataLinkPlay');
			bDataLinkPlaySpawned = True;
		}

		// Call SetConversation(), which returns 
		if (datalinkPlay.SetConversation(activeDataLink))
		{
			datalinkPlay.SetTrigger(datalinkTrigger);

			if (datalinkPlay.StartConversation(Self))
			{
				return True;
			}
			else
			{
				// Datalink must already be playing, or in queue
				if (bDataLinkPlaySpawned)
				{
					datalinkPlay.Destroy();
					datalinkPlay = None;
				}
				
				return False;
			}
		}
		else
		{
			// Datalink must already be playing, or in queue
			if (bDataLinkPlaySpawned)
			{
				datalinkPlay.Destroy();
				datalinkPlay = None;
			}
			return False;
		}
	}
	else
	{
		return False;
	}
}



// ----------------------------------------------------------------------
// ShowCredits()
// This is stuff for setting up custom end credits
// ----------------------------------------------------------------------

function ShowCredits(optional bool bLoadIntro)
{
	local DeusExRootWindow root;
	local MarkistanCreditsWindow winCredits;

	root = DeusExRootWindow(rootWindow);

	if (root != None)
	{
		// Show the credits screen and force the game not to pause
		// if we're showing the credits after the endgame
		winCredits = MarkistanCreditsWindow(root.InvokeMenuScreen(Class'MarkistanCreditsWindow', bLoadIntro));
		winCredits.SetLoadIntro(bLoadIntro);
	}
}

//NOTE: this function was added to stop all the assholes in the world who try to run off with another game's shit.

function RemoveAllInventory()
{
	local Inventory item, nextItem, lastItem;
        local DeusExPlayer Player;

	if (Player.Inventory != None)
	{
		item = Player.Inventory;
		nextItem = item.Inventory;
		lastItem = item;

		do
		{
			if ((item != None) && item.bDisplayableInv || item.IsA('Ammo'))
			{
				// make sure everything is turned off
				if (item.IsA('DeusExWeapon'))
				{
					DeusExWeapon(item).ScopeOff();
					DeusExWeapon(item).LaserOff();
				}
				if (item.IsA('DeusExPickup'))
				{
					if (DeusExPickup(item).bActive)
						DeusExPickup(item).Activate();
				}

   			if (item.IsA('ChargedPickup'))
					Player.RemoveChargedDisplay(ChargedPickup(item));

				Player.DeleteInventory(item);
				item.Destroy();
				item = Player.Inventory;
			}
			else
				item = nextItem;

			if (item != None)
				nextItem = item.Inventory;
		}
		until ((item == None) || (item == lastItem));
	}
}

function bool DXReduceDamage(int Damage, name damageType, vector hitLocation, out int adjustedDamage, bool bCheckOnly)
{
	local float newDamage;
	local float augLevel, skillLevel;
	local float pct;
	local HazMatSuit suit;
	local BallisticArmor armor;
	local bool bReduced;

	bReduced = False;
	newDamage = Float(Damage);

	if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'Radiation') ||
		(damageType == 'HalonGas')  || (damageType == 'PoisonEffect') || (damageType == 'Poison'))
	{
		if (AugmentationSystem != None)
			augLevel = AugmentationSystem.GetAugLevelValue(class'AugEnviro');

		if (augLevel >= 0.0)
			newDamage *= augLevel;

		// get rid of poison if we're maxed out
		if (newDamage ~= 0.0)
		{
			StopPoison();
			drugEffectTimer -= 4;	// stop the drunk effect
			if (drugEffectTimer < 0)
				drugEffectTimer = 0;
		}

		// go through the actor list looking for owned HazMatSuits
		// since they aren't in the inventory anymore after they are used


      //foreach AllActors(class'HazMatSuit', suit)
//			if ((suit.Owner == Self) && suit.bActive)
      if (UsingChargedPickup(class'HazMatSuit'))
			{
				skillLevel = SkillSystem.GetSkillLevelValue(class'SkillEnviro');
				newDamage *= 0.75 * skillLevel;
			}
	}

	if ((damageType == 'Shot') || (damageType == 'Sabot') || (damageType == 'Exploded') || (damageType == 'AutoShot'))
	{
		// go through the actor list looking for owned BallisticArmor
		// since they aren't in the inventory anymore after they are used
      if (UsingChargedPickup(class'BallisticArmor'))
			{
				skillLevel = SkillSystem.GetSkillLevelValue(class'SkillEnviro');
				newDamage *= 0.5 * skillLevel;
			}
      else if (UsingChargedPickup(class'ChainMail'))
			{
				skillLevel = SkillSystem.GetSkillLevelValue(class'SkillEnviro');
				newDamage *= 0.65 * skillLevel;
			}
	}

	if (damageType == 'HalonGas')
	{
		if (bOnFire && !bCheckOnly)
			ExtinguishFire();
	}

	if ((damageType == 'Shot') || (damageType == 'AutoShot'))
	{
		if (AugmentationSystem != None)
			augLevel = AugmentationSystem.GetAugLevelValue(class'AugBallistic');

		if (augLevel >= 0.0)
			newDamage *= augLevel;
	}

	if (damageType == 'EMP')
	{
		if (AugmentationSystem != None)
			augLevel = AugmentationSystem.GetAugLevelValue(class'AugEMP');

		if (augLevel >= 0.0)
			newDamage *= augLevel;
	}

	if ((damageType == 'Burned') || (damageType == 'Flamed') ||
		(damageType == 'Exploded') || (damageType == 'Shocked'))
	{
		if (AugmentationSystem != None)
			augLevel = AugmentationSystem.GetAugLevelValue(class'AugShield');

		if (augLevel >= 0.0)
			newDamage *= augLevel;
	}

	if (newDamage < Damage)
	{
		if (!bCheckOnly)
		{
			pct = 1.0 - (newDamage / Float(Damage));
			SetDamagePercent(pct);
			ClientFlash(0.01, vect(0, 0, 50));
		}
		bReduced = True;
	}
	else
	{
		if (!bCheckOnly)
			SetDamagePercent(0.0);
	}


	//
	// Reduce or increase the damage based on the combat difficulty setting
	//
	if ((damageType == 'Shot') || (damageType == 'AutoShot'))
	{
		newDamage *= CombatDifficulty;

		// always take at least one point of damage
		if ((newDamage <= 1) && (Damage > 0))
			newDamage = 1;
	}

	adjustedDamage = Int(newDamage);

	return bReduced;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     TruePlayerName="Markus Gray"
     SkillPointsTotal=2500
     SkillPointsAvail=2500
     Credits=100
     strStartMap="16_Markistan_1"
     bStartNewGameAfterIntro=True
     CarcassType=Class'Markistan.MarkusGrayMaleCarcass'
     AccelRate=2048.000000
     MultiSkins(0)=Texture'Markistan.Skins.MarkusTex0'
     MultiSkins(1)=Texture'Markistan.Skins.MarkusTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.PantsTex8'
     MultiSkins(3)=Texture'Markistan.Skins.MarkusTex0'
     MultiSkins(4)=Texture'Markistan.Skins.MarkusTex1'
     MultiSkins(5)=Texture'Markistan.Skins.MarkusTex2'
     MultiSkins(6)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     FamiliarName="Markus Gray"
     UnfamiliarName="Markus Gray"
     bCheatsEnabled=True
}
